package com.ejie.ab04b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Mensaje
 * 
 * @author GFI
 */
public class Mensaje implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * key
	 */
	private String key = null;

	/**
	 * isTraducido
	 */
	private boolean traducido = false;

	/**
	 * parametrosKey
	 */
	private List<ParametroKey> parametrosKey = null;

	/**
	 * Constructor para formar mensajes sin parametros y que debe recuperar el
	 * literal de BD.
	 * 
	 *  key            String
	 *
	 * @param key the key
	 */
	public Mensaje(String key) {
		this.key = key;
		this.parametrosKey = null;
	}

	/**
	 * Constructor para formar mensajes con un parametro el cual se indica si se
	 * debe recueprar el parametro de BD.
	 * 
	 *  key            String
	 *  param            String
	 *  isKey            boolean
	 *
	 * @param key the key
	 * @param param the param
	 * @param isKey the is key
	 */
	public Mensaje(String key, String param, boolean isKey) {
		this.key = key;
		this.parametrosKey = new ArrayList<ParametroKey>();
		ParametroKey parametroKey = new ParametroKey(param, isKey);
		this.parametrosKey.add(parametroKey);
	}

	/**
	 * Constructor para formar mensajes con un parametro el cual se debe
	 * recuperar de BD.
	 * 
	 *  key            String
	 *  param            String
	 *
	 * @param key the key
	 * @param param the param
	 */
	public Mensaje(String key, String param) {
		this.key = key;
		this.parametrosKey = new ArrayList<ParametroKey>();
		ParametroKey parametroKey = new ParametroKey(param, true);
		this.parametrosKey.add(parametroKey);
	}

	/**
	 * Constructor para formar mensajes con dos parametros los cuales se deben
	 * recuperar de BD.
	 * 
	 *  key            String
	 *  param1            String
	 *  param2            String
	 *  isKey            boolean
	 *
	 * @param key the key
	 * @param param1 the param 1
	 * @param param2 the param 2
	 * @param isKey the is key
	 */
	public Mensaje(String key, String param1, String param2, boolean isKey) {
		this.key = key;
		this.parametrosKey = new ArrayList<ParametroKey>();
		ParametroKey parametroKey1 = new ParametroKey(param1, isKey);
		ParametroKey parametroKey2 = new ParametroKey(param2, isKey);
		this.parametrosKey.add(parametroKey1);
		this.parametrosKey.add(parametroKey2);
	}

	/**
	 * Method 'getKey'.
	 * 
	 *  String
	 *
	 * @return the key
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * Method 'setKey'.
	 * 
	 *  key
	 *            String
	 *
	 * @param key the new key
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Method 'getParametrosKey'.
	 * 
	 *  List<ParametroKey>
	 *
	 * @return the parametros key
	 */
	public List<ParametroKey> getParametrosKey() {
		return this.parametrosKey;
	}

	/**
	 * Method 'setParametrosKey'.
	 * 
	 *  parametrosKey
	 *            List<ParametroKey>
	 *
	 * @param parametrosKey the new parametros key
	 */
	public void setParametrosKey(List<ParametroKey> parametrosKey) {
		this.parametrosKey = parametrosKey;
	}

	/**
	 * Method 'isTraducido'.
	 * 
	 *  boolean
	 *
	 * @return true, if is traducido
	 */
	public boolean isTraducido() {
		return this.traducido;
	}

	/**
	 * Method 'setTraducido'.
	 * 
	 *  traducido            boolean
	 *
	 * @param traducido the new traducido
	 */
	public void setTraducido(boolean traducido) {
		this.traducido = traducido;
	}

	/**
	 * Comprueba si el mensaje tiene parametros.
	 * 
	 *  boolean
	 *
	 * @return true, if is parametros key list
	 */
	public boolean isParametrosKeyList() {
		return this.parametrosKey != null && !this.parametrosKey.isEmpty();
	}

	/**
	 * Retorna los parametros seguidos por comas.
	 * 
	 *  String
	 *
	 * @return the parametros key str
	 */
	public String getParametrosKeyStr() {
		StringBuilder stb = new StringBuilder();
		if (this.getParametrosKey() != null && !this.getParametrosKey().isEmpty()) {
			Iterator<ParametroKey> itParametrosKey = this.getParametrosKey().iterator();
			boolean isPrimeraVez = true;
			while (itParametrosKey.hasNext()) {
				if (!isPrimeraVez) {
					stb.append(",");
				}
				stb.append(itParametrosKey.next().getValorParametro());
				isPrimeraVez = false;
			}
		}
		return stb.toString();
	}

	/**
	 * Gets the parametros key object.
	 * 
	 *  Object[]
	 *
	 * @return the parametros key object
	 */
	public Object[] getParametrosKeyObject() {
		Object[] objs = null;
		if (this.getParametrosKey() != null && !this.getParametrosKey().isEmpty()) {
			objs = new Object[this.getParametrosKey().size()];
			Iterator<ParametroKey> itParametrosKey = this.getParametrosKey().iterator();
			int i = 0;
			while (itParametrosKey.hasNext()) {
				objs[i] = itParametrosKey.next().getValorParametro();
				i++;
			}
		}
		return objs;
	}
}